class Client
{
  private Expression expression_;
  private Visitor visitor_;

  public Client()
  {
    visitor_ = new VisitorClassique();
  }

  public void setVisitor( Visitor v )
  {
    visitor_ = v;
  }

  public void setExpression( Expression e )
  {
    expression_ = e;
  }

  public int evaluer()
  {
    return expression_.accepter( visitor_ );
  }
}

class Main
{
  public static void main( String args[] )
  {
    Client client = new Client();
    
    Expression moins1 = new Moins();
    Expression quatre = new Nombre( 4 );
    Expression dix = new Nombre( 10 );

    moins1.ajouter( quatre );
    moins1.ajouter( dix );

    Expression moins2 = new Moins();
    Expression quinze = new Nombre( 15 );
    Expression trois = new Nombre( 3 );
    Expression neuf = new Nombre( 9 );

    moins2.ajouter( quinze );
    moins2.ajouter( moins1 );
    moins2.ajouter( trois );
    moins2.ajouter( neuf );

    Expression plus1 = new Plus();
    Expression six = new Nombre( 6 );
    Expression trois2 = new Nombre( 3 ); // je pourrais m'en passer et utiliser 'trois', mais techniquement nous n'aurons plus un arbre.

    plus1.ajouter( six );
    plus1.ajouter( trois2 );
    plus1.ajouter( moins2 );

    client.setExpression( plus1 );

    System.out.println( client.evaluer() );
    
    client.setVisitor( new VisitorBizarre() );

    System.out.println( client.evaluer() );
  }
}
